import pandas as pd  
import matplotlib.pyplot as plt  
from decision_company import read_csv_file, create_subplots, get_fig_from_df, count_unique_values, set_layout, save_plot, show_plots

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  

# Plot histograms  
fig, axes = create_subplots(2, 2, figsize=(12, 8))  
  
get_fig_from_df(count_unique_values(credit_customers['credit_history']),kind='bar', ax=axes[0, 0], title='Credit History')  
get_fig_from_df(count_unique_values(credit_customers['employment']), kind='bar', ax=axes[0, 1], title='Employment')  
get_fig_from_df(credit_customers['age'],kind='hist', bins=20, ax=axes[1, 0], title='Age')  
get_fig_from_df(credit_customers['credit_amount'], kind='hist', bins=20, ax=axes[1, 1], title='Credit Amount')  

set_layout() 
save_plot('ref_result/subplots.png') 
show_plots()  